//@input Component.AnimationMixer[] animMixer

function setPlayableWeight(layerName, animationMixer) {
    var layers = animationMixer.getLayers();
    layers.forEach(function(layer) {
        if (layer.name === layerName) {
            layer.weight = 1;
        } else {
            layer.weight = 0;
        }
    });
}

var action = true

var delayedEvent = script.createEvent("DelayedCallbackEvent");
delayedEvent.bind(function(eventData)
{
    if (!action) {
        runCycle()
        delayedEvent.reset(2);
    } else {
        runAction()
        delayedEvent.reset(1);
    }
    action = !action
});

delayedEvent.reset(0.01);



function runAction() {
    script.animMixer.forEach(function(mixer) {
        setPlayableWeight("action", mixer)
    })
}

function runCycle() {
    script.animMixer.forEach(function(mixer) {
        setPlayableWeight("cycle", mixer)
    })
}



