#define SC_USE_USER_DEFINED_VS_MAIN

#include <std_vs.glsl>

uniform sampler2D background;
uniform mat3 backgroundTransform;

uniform sc_FragmentPrecision vec3 face1;
uniform sc_FragmentPrecision vec3 face2;

#ifdef TUNING
uniform sc_FragmentPrecision vec4 faceShape;
uniform sc_FragmentPrecision vec4 neckShape;
uniform sc_FragmentPrecision vec4 shouldersShape;
#else
#define faceShape vec4(0.0,0.6,0.06,1.4)
#define neckShape vec4(-0.7,0.35,0.09,1.4)
#define shouldersShape vec4(-3.2,1.8,0.2,1.4)
#endif
varying vec4 face0uv;
varying vec4 neck0uv;
varying vec4 shoulder0uv;

#ifdef VERTEX_SHADER
vec2 relateShapeV(vec4 shape,vec3 face){
	vec2 faceCenter=face.xy;
	faceCenter.y+=shape.x*sc_Camera.aspect*face.z;

	vec2 faceToCoords=varScreenTexturePos -faceCenter;
	faceToCoords.y/=(sc_Camera.aspect*shape.w);
	return faceToCoords;
}

void main(void){
	sc_Vertex_t v=sc_LoadVertexAttributes();
	v.texture0=vec2(backgroundTransform*vec3(v.texture0,1.0));
	sc_ProcessVertex(v);

	face0uv=vec4(relateShapeV(faceShape,face1),relateShapeV(faceShape,face2));
	neck0uv=vec4(relateShapeV(neckShape,face1),relateShapeV(neckShape,face2));
	shoulder0uv=vec4(relateShapeV(shouldersShape,face1),relateShapeV(shouldersShape,face2));
}
#endif

#ifdef FRAGMENT_SHADER
float relateShapeF(vec4 shape,vec3 face,vec2 coo){
	float size=shape.y*face.z;
	return smoothstep(size,size+shape.z,length(coo));
}
void main(){
	float alpha=relateShapeF(faceShape,face1,face0uv.xy);
	alpha=min(alpha,relateShapeF(neckShape,face1,neck0uv.xy));
	alpha=min(alpha,relateShapeF(shouldersShape,face1,shoulder0uv.xy));
#ifdef SECOND_FACE
	alpha=min(alpha,relateShapeF(faceShape,face2,face0uv.zw));
	alpha=min(alpha,relateShapeF(neckShape,face2,neck0uv.zw));
	alpha=min(alpha,relateShapeF(shouldersShape,face2,shoulder0uv.zw));
#endif

#ifdef ENABLE_BG_TEX
	vec3 originalColor=texture2D(background,varTex0+varScreenTexturePos*0.0001).xyz;
#else
	vec3 originalColor=vec3(1.0);
#endif
#ifdef sc_BlendMode_Disabled
	gl_FragColor=vec4(originalColor*(1.0-alpha),1.0);
#else
	gl_FragColor=vec4(originalColor,1.0-alpha);
#endif
}

#endif

#if sc_IsEditor
#error This is an exported shader. Please do not use shaders in Studio that have already been exported to a lens! Only use fresh shaders,presets,or shaders from existing Studio projects!
#endif

/// Exported with Lens Studio 3.2.0.0 Internal
