//@input Asset.Material[] materials
//@input vec3[] colors

//@input float alpha

//@input string key

var index = 0
applyIndex(index)

script.createEvent("TouchStartEvent").bind(function(){
	index++
	index %= script.colors.length
	applyIndex(index)
    
    if (!!global.persistentStorageSystem.store) {
        global.persistentStorageSystem.store.putInt(script.api.key, index);
    }
})



function applyIndex(index){

	var remapColors = script.colors[index].uniformScale(1.0 / 255.0)
	script.materials.forEach(function(item){
		item.mainPass.baseColor = new vec4(remapColors.x, remapColors.y, remapColors.z, script.alpha)
	})
}

script.api.key = script.key
script.api.setFromStore = function(storedIndex) {
    index = storedIndex
    applyIndex(index)
}
