//@input Component.SpriteVisual bilboard
//@input SceneObject facialHair
//@input SceneObject effect
//@input Asset.Texture segmentMask

global.DEVICE_CLASS = global.deviceInfoSystem.getDeviceClass();

var sceneObject = scene.createSceneObject("")

var head = sceneObject.createComponent("Head")
head.faceIndex = 0

var pass = script.bilboard.mainPass

pass.face1 = new vec3(10, 10, 0)
pass.face2 = new vec3(10, 10, 0)
pass.flipMaskVertically = 1.0;
var newtime = 0.0;
function enableEffects(bEnable) {
    script.facialHair.enabled = bEnable;
    script.effect.enabled = bEnable;
}

var frameCount = 0;
pass.firstRun = 1.0
enableEffects(false);

if(global.DEVICE_CLASS >= 2) {
        pass.texMask = script.segmentMask;
        pass.flipMaskVertically = 0.0;
    }

//------------------------upd-----------------------------------
function upd(eventData) {

    var pass = script.bilboard.mainPass

    if (frameCount==3) {
        pass.firstRun = 0.0
        enableEffects(true);
    }
    frameCount += 1

    if (head.getFacesCount() > 0) {
        var t = Math.min(newtime, 1.0);
        pass.mixSpeed = 4.0 - 3.8*t*t;
        newtime += 2.0*getDeltaTime();

        var left = head.getPosition2d(0)
        left.y = 1 - left.y
        
        var right = head.getPosition2d(16)
        right.y = 1 - right.y
        
        var faceCenter = left.add(right).div(new vec2(2, 2))
        
        var size = head.getSize()
        var maxsize = size.x <= size.y ? size.y : size.x
        pass.face1 = new vec3(faceCenter.x, faceCenter.y, maxsize)
        
        pass.face1dir = left.sub(right).normalize()
 
    } else {
        newtime = 0.0;
        pass.mixSpeed = 0.0; // do not update average color if no face found
        pass.face1 = new vec3(10, 10, 0)
    }
}

var updEvent = script.createEvent("UpdateEvent")
updEvent.bind(upd)
