
//------------------------------------------------------//
//------------------DEVICE WHITELIST--------------------//
//------------------------------------------------------//
//@input bool useDeviceWhitelist = true

const SUPPORTED_ANDROID_DEVICE_MODELS = [
    /*ONE PLUS 5*/
    "ONEPLUS A5000", "A5000",
    /*ONE PLUS 5T*/
    "ONEPLUS A5010", "A5010",
    /*GOOGLE PIXEL 2*/
    "PIXEL 2", "PIXEL 2 XL"
  ];
  
  script.DEVICE_CLASS_MAP = {
    BARELY_WORKING: 0,
    LOW_END: 1,
    MID_END: 2,
    HIGH_END: 3
  }
  
  global.DEVICE_CLASS = global.deviceInfoSystem.getDeviceClass();
  global.TARGET_OS = global.deviceInfoSystem.getTargetOS().toLowerCase();
  
  script.supportedAndroidDevices = {};
  
  script.buildDeviceMap =function(baseSupportedDevicesList) {
    for (var i = 0; i < baseSupportedDevicesList.length; ++i) {
      script.supportedAndroidDevices[baseSupportedDevicesList[i]] = true;
      if (baseSupportedDevicesList[i].indexOf('SM-') != -1) {
        script.supportedAndroidDevices['SAMSUNG-' + baseSupportedDevicesList[i]] = true;
      }
    }
  }
  
  script.safeGetDeviceModel = function() {
    return typeof global.deviceInfoSystem.getDeviceModel === 'function' ? global.deviceInfoSystem.getDeviceModel() : 'UNKNOWN';
  }
  
  global.isDeviceSupported = function() {
    if (!script.useDeviceWhitelist) {
      return true;  
    }
  
    script.buildDeviceMap(SUPPORTED_ANDROID_DEVICE_MODELS);
  
    if (global.TARGET_OS == "macos" ||  global.TARGET_OS != "android") {
        return true;
    }
  
    var deviceModelStr = script.safeGetDeviceModel();
    const deviceModel = deviceModelStr.toUpperCase();
    if (script.supportedAndroidDevices[deviceModel] !== true) {
      return false;
    }
  
    return true;
  }
